/*------------------------------------------------------------------------------*
 * File Name:				 													*
 * Creation: 																	*
 * Purpose: OriginC Source C file												*
 * Copyright (c) ABCD Corp.	2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010		*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
// Including the system header file Origin.h should be sufficient for most Origin
// applications and is recommended. Origin.h includes many of the most common system
// header files and is automatically pre-compiled when Origin runs the first time.
// Programs including Origin.h subsequently compile much more quickly as long as
// the size and number of other included header files is minimized. All NAG header
// files are now included in Origin.h and no longer need be separately included.
//
// Right-click on the line below and select 'Open "Origin.h"' to open the Origin.h
// system header file.
#include <Origin.h>
////////////////////////////////////////////////////////////////////////////////////

//#pragma labtalk(0) // to disable OC functions for LT calling.

////////////////////////////////////////////////////////////////////////////////////
// Include your own header files here.
#include <Dialog.h>
#include "WizardRes.h" //OWizard resource relative
#include "Wizard.h"

//Function to launch wizard dialog
bool DoWizard() 
{
	OCWizardDlg oWizard;
	oWizard.DoModal(GetWindow());
	return true;
}


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////Base Wizard Page Class///////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
//virtual
BOOL	WizardPage::OnActivatePage()
{
	PlaceHolder holder;
	holder = GetParent();
	if ( holder )
		holder.ActivePageChanged();
	
	return TRUE;
}

void	WizardPage::Init(TreeNode& trSettings)
{
	m_trSettings = trSettings;
}


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////Derived Wizard Page Class///////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
BOOL	SecondPage::OnKillActivatePage() //save settings when switch to another page
{
	TreeNode trText = tree_check_get_node(m_trSettings, STR_USER_TEXT);
	trText.strVal = GetItem(IDC_EDIT_TEXT).Text; //save the text.
	return WizardPage::OnKillActivatePage();
}


//virtual
BOOL	ThirdPage::OnActivatePage() //load settings updated by previous pages.
{
	TreeNode trText = m_trSettings.GetNode(STR_USER_TEXT);
	ASSERT(trText);
	if ( trText )
		GetItem(IDC_EDIT_TEXT).Text = trText.strVal; //display the text.
	
	return WizardPage::OnActivatePage();
}

////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////Page Holder Class//////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
PlaceHolder::PlaceHolder() //add pages to placeholder.
{
	m_First.SetID(IDD_OWIZARD_FIRST_PAGE);
	AddPage(m_First);
	
	m_Second.SetID(IDD_OWIZARD_SECOND_PAGE);
	AddPage(m_Second);
	
	m_Third.SetID(IDD_OWIZARD_THIRD_PAGE);
	AddPage(m_Third);
	
	m_Last.SetID(IDD_OWIZARD_LAST_PAGE);
	AddPage(m_Last);
	
	m_Second.Init(m_trSettings); //make sure the page has a reference to the settings storage
	m_Third.Init(m_trSettings); //make sure the page has a reference to the settings storage
	
	AddPathControl(40); //Wizard Map on left, 40% of the width of the main dialog. If do NOT want to show it, just comment out this line.
}
		
BOOL		PlaceHolder::ActivePageChanged()
{
	OCWizardDlg oWizard;
	oWizard = GetParent();
	if ( oWizard )
		oWizard.PostMessage(WM_USER_PAGE_CHANGE, 0, 0); //notify parent to do things when page changed.
	return TRUE;
}
	
void		PlaceHolder::InitMaps()
{
	//init message map for each page.
	m_First.InitMsgMap();
	m_Second.InitMsgMap();
	m_Third.InitMsgMap();
	m_Last.InitMsgMap();
}
	
TreeNode	PlaceHolder::GetSettings()
{
	return m_trSettings;
}


////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////Dialog Class/////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////
int		OCWizardDlg::DoModal(HWND hParent)
{
	InitMsgMap(); //will be called from internal later
	int nRet = Dialog::DoModal(hParent);
	return nRet;
}
	

BOOL	OCWizardDlg::OnInitDialog()
{
	//init placeholder.
	m_Holder.Create(IDC_PAGE_PLACEHOLDER, *this);
	m_Holder.InitMaps();
	
	//init dialog controls
	m_btnPrev = GetItem(ID_PREV);
	m_btnNext = GetItem(ID_NEXT);
	m_btnPrev.Enable = false;
	return TRUE;
}
	
BOOL	OCWizardDlg::OnFinish(Control trl)
{
	m_Holder.NextPage(); //in order to save settings on current page.
	TreeNode trSettings = m_Holder.GetSettings();
	out_tree(trSettings); //dump user settings.
	Close(); //close the dialog after click Finish button
	return TRUE;
}
	
//need to check and update button enable/disable state
BOOL	OCWizardDlg::OnActivePageChanged(UINT wParam, UINT lParam)
{
	if ( m_Holder.GetActiveIndex() == 0 )
		m_btnPrev.Enable = false;
	else
		m_btnPrev.Enable = true;
	
	if ( m_Holder.GetActiveIndex() == m_Holder.GetPageCount() - 1 )
		m_btnNext.Enable = false;
	else
		m_btnNext.Enable = true;
	
	return TRUE;
}

//when click Next button
BOOL	OCWizardDlg::OnNext(Control ctrl)
{
	m_Holder.NextPage();
	return TRUE;
}

BOOL	OCWizardDlg::OnPrev(Control ctrl)
{
	m_Holder.PrevPage();
	return TRUE;
}
